/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.block;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.block.BlockComponentData;
import com.technicalitiesmc.lib.block.CustomBlockHighlight;
import com.technicalitiesmc.lib.block.TKBlock;
import com.technicalitiesmc.lib.block.TKBlockEntity;
import com.technicalitiesmc.lib.block.component.BlockData;
import com.technicalitiesmc.lib.block.multipart.BlockSlot;
import com.technicalitiesmc.lib.block.multipart.FaceSlot;
import com.technicalitiesmc.lib.block.multipart.Multipart;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.math.IndexedBlockHitResult;
import com.technicalitiesmc.lib.math.MergedShape;
import com.technicalitiesmc.lib.math.Vec2i;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.circuit.CircuitAdjacency;
import com.technicalitiesmc.scm.circuit.CircuitHelper;
import com.technicalitiesmc.scm.circuit.TileAccessor;
import com.technicalitiesmc.scm.circuit.TilePointer;
import com.technicalitiesmc.scm.circuit.client.ClientTile;
import com.technicalitiesmc.scm.circuit.server.Circuit;
import com.technicalitiesmc.scm.circuit.server.CircuitCache;
import com.technicalitiesmc.scm.circuit.server.ComponentInstance;
import com.technicalitiesmc.scm.circuit.server.ServerTileAccessor;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import com.technicalitiesmc.scm.circuit.util.TilePos;
import com.technicalitiesmc.scm.client.ClientConfig;
import com.technicalitiesmc.scm.client.model.CircuitModelData;
import com.technicalitiesmc.scm.init.SCMBlockEntities;
import com.technicalitiesmc.scm.init.SCMBlocks;
import com.technicalitiesmc.scm.init.SCMItemTags;
import com.technicalitiesmc.scm.network.ComponentBreakPacket;
import com.technicalitiesmc.scm.network.ComponentSyncPacket;
import com.technicalitiesmc.scm.network.ComponentUsePacket;
import com.technicalitiesmc.scm.network.SCMNetworkHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class CircuitBlock
extends TKBlock.WithEntity
implements Multipart,
CustomBlockHighlight {
    private static final Capability<Data> DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Data>(){});
    private static final AABB CLICK_TILE_AABB = new AABB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    public static final Property<Direction> DIRECTION = DirectionProperty.m_156003_((String)"face");
    public static boolean picking;
    public static VoxelShape boundingBoxOverride;
    private final BlockData<Data> data = (BlockData)this.addComponent("circuit", BlockData.of(Data::new));
    private static final VoxelShape[] BOUNDS;
    private static final VoxelShape[] GRIDS;

    public CircuitBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(3.0f, 6.0f).m_60999_(), SCMBlockEntities.CIRCUIT, new Property[0]);
    }

    @Nullable
    public Object getInterface(Class<?> itf) {
        if (itf == CustomBlockHighlight.class) {
            return this;
        }
        return super.getInterface(itf);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION});
    }

    @Nullable
    public BlockSlot getSlot(BlockState state) {
        return FaceSlot.of((Direction)((Direction)state.m_61143_(DIRECTION)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(DIRECTION, (Comparable)Direction.DOWN);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        return direction != null && direction.m_122434_() != Direction.Axis.Y;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (side.m_122434_() == Direction.Axis.Y) {
            return 0;
        }
        Data data = (Data)this.data.at(level, pos, state);
        return data != null ? data.outputs[side.m_122424_().m_122416_()] / 17 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.m_6378_(state, level, pos, side);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean unknown) {
        super.m_6861_(state, level, pos, block, neighborPos, unknown);
        Data data = (Data)this.data.at((BlockGetter)level, pos, state);
        if (data == null) {
            return;
        }
        VecDirectionFlags sides = VecDirectionFlags.none();
        for (Direction side : Direction.Plane.HORIZONTAL) {
            VecDirection dir;
            int hIndex;
            int input = level.m_46681_(pos.m_142300_(side), side) * 17;
            if (input != data.inputs[hIndex = (dir = VecDirection.fromDirection((Direction)side)).getHorizontalIndex()]) {
                sides = (VecDirectionFlags)sides.and((Enum)dir);
            }
            data.inputs[hIndex] = input;
        }
        if (sides.isEmpty()) {
            return;
        }
        ServerTileAccessor accessor = data.getAccessor();
        accessor.onInputsUpdated(sides);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Data data;
        ComponentSlotPos hitPos;
        Vec3 end;
        boolean partialTickTime;
        Vec3 start;
        VoxelShape shape = this.m_5940_(state, level, pos, CollisionContext.m_82750_((Entity)player));
        BlockHitResult hit = shape.m_83220_(start = player.m_20299_((float)(partialTickTime = false)), start.m_82549_(end = player.m_20252_((float)partialTickTime).m_82542_(10.0, 10.0, 10.0)), pos);
        if (hit != null && (hitPos = CircuitBlock.resolveHit(hit)) != null && hitPos.pos().y() != -1 && (data = (Data)this.data.at(level, pos, state)) != null) {
            ClientTile ct;
            ComponentState componentState;
            TileAccessor accessor = data.getOrCreateAccessor();
            if (accessor instanceof ServerTileAccessor) {
                ServerTileAccessor sta = (ServerTileAccessor)accessor;
                ComponentInstance component = sta.get(hitPos.toAbsolute().pos(), hitPos.slot());
                if (component != null) {
                    return component.getPickedItem();
                }
            } else if (accessor instanceof ClientTile && (componentState = (ct = (ClientTile)accessor).getState(hitPos.toAbsolute().pos(), hitPos.slot())) != null) {
                if (picking) {
                    componentState.onPicking(player);
                    picking = false;
                }
                return componentState.getPickedItem();
            }
        }
        return new ItemStack((ItemLike)this);
    }

    private VoxelShape getBaseShape(BlockState state) {
        return BOUNDS[((Direction)state.m_61143_(DIRECTION)).ordinal()];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getBaseShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getBaseShape(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (boundingBoxOverride != null) {
            return boundingBoxOverride;
        }
        Data data = (Data)this.data.at(level, pos, state);
        VoxelShape baseShape = this.getBaseShape(state);
        if (data == null || data.hideComponents) {
            return baseShape;
        }
        TileAccessor accessor = data.getOrCreateAccessor();
        if (accessor == null) {
            return baseShape;
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(baseShape);
        accessor.visitAreaShapes(shapes::add);
        if (accessor instanceof ClientTile) {
            Player p;
            EntityCollisionContext ecc;
            Entity entity;
            ClientTile ct = (ClientTile)accessor;
            if (context instanceof EntityCollisionContext && (entity = (ecc = (EntityCollisionContext)context).m_193113_()) instanceof Player && (p = (Player)entity).m_21120_(InteractionHand.MAIN_HAND).m_204117_(SCMItemTags.SHOWS_CIRCUIT_GRID)) {
                boolean nx = ct.hasNeighbor(Vec2i.NEG_X);
                boolean px = ct.hasNeighbor(Vec2i.POS_X);
                boolean nz = ct.hasNeighbor(Vec2i.NEG_Y);
                boolean pz = ct.hasNeighbor(Vec2i.POS_Y);
                shapes.add(GRIDS[0]);
                if (nx) {
                    shapes.add(GRIDS[1]);
                }
                if (px) {
                    shapes.add(GRIDS[2]);
                }
                if (nz) {
                    shapes.add(GRIDS[3]);
                }
                if (pz) {
                    shapes.add(GRIDS[4]);
                }
                if (nx && nz && ct.hasNeighbor(Vec2i.NEG_X_NEG_Y)) {
                    shapes.add(GRIDS[5]);
                }
                if (nx && pz && ct.hasNeighbor(Vec2i.NEG_X_POS_Y)) {
                    shapes.add(GRIDS[6]);
                }
                if (px && pz && ct.hasNeighbor(Vec2i.POS_X_POS_Y)) {
                    shapes.add(GRIDS[7]);
                }
                if (px && nz && ct.hasNeighbor(Vec2i.POS_X_NEG_Y)) {
                    shapes.add(GRIDS[8]);
                }
            }
        }
        return MergedShape.of((VoxelShape)baseShape, shapes);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        TileAccessor accessor;
        Data data = (Data)this.data.at(level, pos, state);
        if (data != null && (accessor = data.getOrCreateAccessor()) != null && !accessor.isAreaEmpty() && !player.m_6047_()) {
            return 0.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        Data data;
        if (!(state.m_60713_(newState.m_60734_()) || level.m_5776_() || moving || (data = (Data)this.data.at((BlockGetter)level, pos, state)) == null)) {
            ServerTileAccessor accessor = data.getAccessor();
            accessor.clearAndRemove(ComponentHarvestContext.drop((ServerLevel)((ServerLevel)level), data::drop));
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        TileAccessor accessor;
        boolean shouldRemove;
        Data data = (Data)this.data.at((BlockGetter)level, pos, state);
        boolean bl = shouldRemove = data == null;
        if (!shouldRemove) {
            accessor = data.getOrCreateAccessor();
            boolean bl2 = shouldRemove = accessor == null || accessor.isAreaEmpty();
        }
        if ((shouldRemove |= player.m_6047_()) && !level.m_5776_() && data != null) {
            accessor = data.getAccessor();
            ((ServerTileAccessor)accessor).clearAndRemove(ComponentHarvestContext.forPlayer((Player)player));
        }
        return shouldRemove && super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public boolean isStickyBlock(BlockState state) {
        return true;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        return other.m_60713_((Block)this) && state.m_61143_(DIRECTION) == other.m_61143_(DIRECTION);
    }

    public InteractionResult onClientUse(BlockState state, ClientLevel level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileAccessor tileAccessor;
        ComponentSlotPos hitPos = CircuitBlock.resolveHit(hit);
        if (hitPos == null || hitPos.pos().y() == -1) {
            if (((Boolean)ClientConfig.Debug.allowHidingComponents.get()).booleanValue() && player.m_21205_().m_204117_(SCMItemTags.DBG_HIDES_COMPONENTS)) {
                Data data = (Data)this.data.at((BlockGetter)level, pos, state);
                if (data != null) {
                    data.hideComponents = !data.hideComponents;
                    data.onUpdateReceived();
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        Data data = (Data)this.data.at((BlockGetter)level, pos, state);
        if (data == null || !((tileAccessor = data.getOrCreateAccessor()) instanceof ClientTile)) {
            return InteractionResult.PASS;
        }
        ClientTile ct = (ClientTile)tileAccessor;
        ComponentState s = ct.getState(hitPos.toAbsolute().pos(), hitPos.slot());
        if (s == null) {
            return InteractionResult.PASS;
        }
        Vec3 scaledHit = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)hit.m_82425_())).m_82520_(0.0625, -0.125, 0.0625).m_82490_(8.0);
        Vector3f hitVec = new Vector3f((float)scaledHit.m_7096_() % 1.0f, (float)scaledHit.m_7098_() % 1.0f, (float)scaledHit.m_7094_() % 1.0f);
        VecDirection sideHit = VecDirection.fromDirection((Direction)hit.m_82434_());
        SCMNetworkHandler.sendToServer(new ComponentUsePacket(pos, hitPos.toAbsolute().pos(), hitPos.slot(), hand, sideHit, hitVec));
        return s.use(player, hand, sideHit, hitVec);
    }

    public InteractionResult onClientClicked(BlockState state, ClientLevel level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ComponentSlotPos hitPos = CircuitBlock.resolveHit(hit);
        if (hitPos == null || hitPos.pos().y() < 0) {
            return InteractionResult.PASS;
        }
        SCMNetworkHandler.sendToServer(new ComponentBreakPacket(pos, hitPos.toAbsolute().pos(), hitPos.slot()));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : this::tickEntity;
    }

    private void tickEntity(Level level, BlockPos pos, BlockState blockState, BlockEntity entity) {
        TileAccessor tileAccessor;
        if (!(entity instanceof TKBlockEntity)) {
            return;
        }
        TKBlockEntity e = (TKBlockEntity)entity;
        Data data = (Data)e.get(this.data);
        if (data != null && (tileAccessor = data.getOrCreateAccessor()) instanceof ServerTileAccessor) {
            ServerTileAccessor sta = (ServerTileAccessor)tileAccessor;
            sta.scheduleTick(level);
        }
    }

    @Nullable
    public static ComponentSlotPos resolveHit(BlockHitResult blockHit) {
        IndexedBlockHitResult hit;
        if (!(blockHit instanceof IndexedBlockHitResult) || !(hit = (IndexedBlockHitResult)blockHit).hasIndex()) {
            return null;
        }
        return CircuitHelper.resolvePositionFromShapeIndex(hit.getIndex());
    }

    public static VoxelShape makeGrid(int startX, int endX, int startZ, int endZ, int yPos) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (int x = startX; x < endX; ++x) {
            for (int z = startZ; z < endZ; ++z) {
                shapes.add(CircuitHelper.createShape(CLICK_TILE_AABB, new ComponentPos(x, yPos, z), ComponentSlot.DEFAULT));
            }
        }
        return MergedShape.ofMerged(shapes);
    }

    static {
        BOUNDS = new VoxelShape[]{CircuitBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), CircuitBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), CircuitBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), CircuitBlock.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), CircuitBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), CircuitBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
        GRIDS = new VoxelShape[]{CircuitBlock.makeGrid(0, 7, 0, 7, -1), CircuitBlock.makeGrid(-1, 0, 0, 7, -1), CircuitBlock.makeGrid(7, 8, 0, 7, -1), CircuitBlock.makeGrid(0, 7, -1, 0, -1), CircuitBlock.makeGrid(0, 7, 7, 8, -1), CircuitBlock.makeGrid(-1, 0, -1, 0, -1), CircuitBlock.makeGrid(-1, 0, 7, 8, -1), CircuitBlock.makeGrid(7, 8, 7, 8, -1), CircuitBlock.makeGrid(7, 8, -1, 0, -1)};
    }

    public static class Data
    extends BlockComponentData<BlockData<?>>
    implements ServerTileAccessor.Host,
    ClientTile.Host {
        private final LazyOptional<Data> self = LazyOptional.of(() -> this);
        @Nullable
        private TilePointer tilePointer;
        private final int[] inputs = new int[4];
        private final int[] outputs = new int[4];
        @Deprecated
        private boolean hideComponents;
        @Nullable
        private TileAccessor accessor;

        public Data(BlockComponentData.Context context) {
            super(context);
        }

        @Nullable
        private MinecraftServer getServer() {
            Level level = this.getLevel();
            return level != null ? level.m_142572_() : null;
        }

        @Nullable
        public TileAccessor getOrCreateAccessor() {
            return this.getOrCreateAccessor(this.getServer());
        }

        @Nullable
        public TileAccessor getOrCreateAccessor(@Nullable MinecraftServer server) {
            if (this.accessor != null) {
                return this.accessor;
            }
            if (server == null) {
                this.accessor = new ClientTile(this);
                return this.accessor;
            }
            if (this.tilePointer == null) {
                this.tilePointer = new TilePointer(UUID.randomUUID(), TilePos.ZERO);
            }
            Circuit circuit = CircuitCache.getOrCreate(server, this.tilePointer.id());
            this.accessor = circuit.claim(this.tilePointer.tilePos(), this);
            if (this.accessor != null) {
                return this.accessor;
            }
            this.tilePointer = null;
            return this.getOrCreateAccessor(server);
        }

        public void onChunkUnloaded() {
            super.onChunkUnloaded();
            TileAccessor tileAccessor = this.accessor;
            if (tileAccessor instanceof ServerTileAccessor) {
                ServerTileAccessor sta = (ServerTileAccessor)tileAccessor;
                sta.releaseClaim();
            }
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == DATA_CAPABILITY) {
                return this.self.cast();
            }
            return super.getCapability(cap, side);
        }

        public void addModelData(ModelDataMap.Builder builder) {
            TileAccessor accessor = this.getOrCreateAccessor(null);
            if (accessor instanceof ClientTile) {
                ClientTile ct = (ClientTile)accessor;
                builder.withInitial(CircuitModelData.PROPERTY, (Object)ct.getModelData(this.hideComponents));
            }
        }

        public CompoundTag save(CompoundTag tag) {
            tag = super.save(tag);
            if (this.tilePointer != null) {
                tag.m_128365_("pointer", (Tag)this.tilePointer.save(new CompoundTag()));
            }
            tag.m_128385_("inputs", this.inputs);
            tag.m_128385_("outputs", this.outputs);
            return tag;
        }

        public void load(CompoundTag tag) {
            super.load(tag);
            this.tilePointer = tag.m_128441_("pointer") ? new TilePointer(tag.m_128469_("pointer")) : null;
            int[] inputs = tag.m_128465_("inputs");
            System.arraycopy(inputs, 0, this.inputs, 0, inputs.length);
            int[] outputs = tag.m_128465_("outputs");
            System.arraycopy(outputs, 0, this.outputs, 0, outputs.length);
        }

        public CompoundTag saveDescription(CompoundTag tag) {
            tag = super.saveDescription(tag);
            tag.m_128365_("tile", (Tag)this.getAccessor().describe(new CompoundTag()));
            return tag;
        }

        public void loadDescription(CompoundTag tag) {
            super.loadDescription(tag);
            this.accessor = ClientTile.fromDescription(this, tag.m_128469_("tile"));
        }

        @Nullable
        private Data getCircuitData(Vec2i offset) {
            BlockPos pos = this.getBlockPos().m_142082_(offset.x(), 0, offset.y());
            BlockEntity entity = this.getLevel().m_7702_(pos);
            if (entity == null) {
                return null;
            }
            return (Data)entity.getCapability(DATA_CAPABILITY).orElse(null);
        }

        @Override
        public ServerTileAccessor getAccessor() {
            ServerTileAccessor sta;
            TileAccessor tileAccessor = this.getOrCreateAccessor(this.getServer());
            return tileAccessor instanceof ServerTileAccessor ? (sta = (ServerTileAccessor)tileAccessor) : null;
        }

        @Override
        @Nullable
        public ServerTileAccessor.Host find(Vec2i offset) {
            return this.getCircuitData(offset);
        }

        @Override
        public void updatePointer(TilePointer pointer) {
            this.tilePointer = pointer;
            this.markUnsaved();
        }

        @Override
        public void syncState(Map<ComponentSlotPos, ComponentState> states, CircuitAdjacency[] adjacency) {
            MinecraftServer server = this.getServer();
            if (server == null) {
                return;
            }
            ComponentSyncPacket packet = new ComponentSyncPacket(this.getBlockPos(), new HashMap<ComponentSlotPos, ComponentState>(states), adjacency);
            SCMNetworkHandler.broadcastToClientsWatching(packet, (ServerLevel)this.getLevel(), new ChunkPos(this.getBlockPos()));
        }

        @Override
        public void drop(ItemStack stack) {
            Utils.dropItemAt((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (ItemStack)stack);
        }

        @Override
        public void playSound(SoundEvent sound, SoundSource source, float volume, float pitch) {
            Level level = this.getLevel();
            BlockPos pos = this.getBlockPos();
            level.m_5594_(null, pos, sound, source, volume, pitch);
        }

        @Override
        public int getInput(VecDirection side) {
            return this.inputs[side.getHorizontalIndex()];
        }

        @Override
        public void setOutput(VecDirection side, int value) {
            Direction dir = Direction.m_122387_((Direction.Axis)side.getAxis(), (Direction.AxisDirection)side.getAxisDirection());
            this.outputs[dir.m_122416_()] = value;
            this.getLevel().m_46672_(this.getBlockPos(), (Block)SCMBlocks.CIRCUIT.get());
            this.getLevel().m_46672_(this.getBlockPos().m_142300_(dir), (Block)SCMBlocks.CIRCUIT.get());
        }

        @Override
        @Nullable
        public ClientTile getClientNeighbor(Vec2i offset) {
            Data data = this.getCircuitData(offset);
            return data != null ? (ClientTile)data.getOrCreateAccessor(null) : null;
        }

        @Override
        public void onUpdateReceived() {
            this.markDataUpdated();
            Level level = this.getLevel();
            if (level instanceof ClientLevel) {
                ClientLevel level2 = (ClientLevel)level;
                level2.m_7260_(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
            }
        }
    }
}

